#Supplemental_Fig_S6:
aa_protein_lengths <- read.delim("C:/Gresham/tiny_projects/Project_Grace/Review_GB/aa_protein_lengths.tsv", header=FALSE)
calc_insertion_median <- read.delim("C:/Gresham/tiny_projects/Project_Grace/Review_GB/calc_insertion_median.txt")

unity<-merge(aa_protein_lengths,calc_insertion_median, by.x="V2", by.y="X")
write.csv(unity, "C:/Gresham/tiny_projects/Project_Grace/Review_GB/unity.csv")



essential <-read.delim('C:/Gresham/tiny_projects/Project_Grace/insertions/Essential_ORFs.txt')

essential_unity <- merge(essential, unity, by.x = "essential_genes", by.y = "V2")

#essential <-read.delim('C:/Gresham/tiny_projects/Project_Grace/insertions/Essential_ORFs.txt')

pdf('C:/Gresham/tiny_projects/Project_Grace/Review_GB/Adj.R-squared_DGY1657_insertions.pdf')
plot(log2(unity$X1657_1),log2(unity$X1657_2))
fit <- lm(log2(unity$X1657_2) ~ log2(unity$X1657_1))
summary(fit)
abline(fit)
dev.off()

pdf('C:/Gresham/tiny_projects/Project_Grace/Review_GB/Adj.R-squared_length_insertions.pdf')
plot(log2(unity$V1),log2(unity$median))
fit <- lm(log2(unity$median) ~ log2(unity$V1))
summary(fit)
dev.off()

#BMH1 / YER177W # pass
unity <- replace(unity, is.na(unity), 0)
unity_aa_267<-subset(unity, unity$V1==267)
median(unity_aa_267$median)
YER177W<-subset(unity, unity$V2=='YER177W')
median(YER177W$median)

#PAU11 / YGL261C
unity_aa_120<-subset(unity, unity$V1==120)
median(unity_aa_120$median)
YGL261C<-subset(unity, unity$V2=='YGL261C')
median(YER177W$median)


#RIO2 / YNL207W 
unity_aa_425<-subset(unity, unity$V1==425)
median(unity_aa_425$median)
YNL207W<-subset(unity, unity$V2=='YNL207W')
median(YER177W$median)

#RPF2 / YKR081C 
unity_aa_344<-subset(unity, unity$V1==344)
median(unity_aa_344$median)
YKR081C<-subset(unity, unity$V2=='YKR081C')
median(YKR081C$median)

#RPS21A / YKR057W
unity_aa_87<-subset(unity, unity$V1==87)
median(unity_aa_87$median)
YKR057W<-subset(unity, unity$V2=='YKR057W')
median(YKR057W$median)

#TIF1 / YKR059W
unity_aa_395<-subset(unity, unity$V1==395)
median(unity_aa_395$median)
YKR059W<-subset(unity, unity$V2=='YKR059W')
median(YKR059W$median)

#TMA19 / YKL056C
unity_aa_167<-subset(unity, unity$V1==167)
median(unity_aa_167$median)
YKL056C<-subset(unity, unity$V2=='YKL056C')
median(YKL056C$median)

#Supplemental question - CNV expression difference:
diff_exp <- read.delim("C:/Gresham/tiny_projects/Project_Grace/Review_GB/cnv_expression_difference.tsv")
Fitness_Final_Lauer2018 <- read.csv("C:/Gresham/tiny_projects/Project_Grace/Review_GB/Fitness_Final_Lauer2018.csv")

unity<-merge(diff_exp, Fitness_Final_Lauer2018, by.x="strain", by.y='clone')

plot(unity$tpm_diff, unity$fitness_coef...1)
fit <- lm(unity$fitness_coef...1 ~ unity$tpm_diff)
summary(fit)

rel_growth_YPGal <- read.csv("C:/Gresham/tiny_projects/Project_Grace/Review_GB/rel_growth_YPGal.csv")

unity<-merge(diff_exp, rel_growth_YPGal, by="strain")

plot(unity$tpm_diff, unity$mean_r_norm)
fit <- lm(unity$mean_r_norm ~ unity$tpm_diff)
summary(fit)

#Supplemental_Fig_S3:
Strain_nt_added_sizes <- read.delim("C:/Gresham/tiny_projects/Project_Grace/Review_GB/Strain_nt_added_sizes.txt")
Fitness_Final_Lauer2018 <- read.csv("C:/Gresham/tiny_projects/Project_Grace/Review_GB/Fitness_Final_Lauer2018.csv")

unity<-merge(Strain_nt_added_sizes, Fitness_Final_Lauer2018, by.x="strain", by.y='clone')

plot(unity$cnv_bases, unity$fitness_coef...1)
fit <- lm(unity$fitness_coef...1 ~ unity$cnv_bases)
summary(fit)

plot(unity$gene_num, unity$fitness_coef...1)
fit <- lm(unity$fitness_coef...1 ~ unity$gene_num)
summary(fit)

plot(unity$total_bases, unity$fitness_coef...1)
fit <- lm(unity$fitness_coef...1 ~ unity$total_bases)
summary(fit)

#Supplemental_Fig_S3:
Strain_nt_added_sizes <- read.delim("C:/Gresham/tiny_projects/Project_Grace/Review_GB/Strain_nt_added_sizes.txt")
rel_growth_YPGal <- read.csv("C:/Gresham/tiny_projects/Project_Grace/Review_GB/rel_growth_YPGal.csv")

unity<-merge(Strain_nt_added_sizes, rel_growth_YPGal, by="strain")

plot(unity$cnv_bases, unity$mean_r_norm)
fit <- lm(unity$mean_r_norm ~ unity$cnv_bases)
summary(fit)

plot(unity$gene_num, unity$mean_r_norm)
fit <- lm(unity$mean_r_norm ~ unity$gene_num)
summary(fit)

plot(unity$total_bases, unity$mean_r_norm)
fit <- lm(unity$mean_r_norm ~ unity$total_bases)
summary(fit)

#Supplemental_Fig_S17 
library(scales)
mic_raw <- read.delim("C:/Gresham/tiny_projects/Project_Grace/Review_GB/trans_per_insert/mrna_insertions_cn_combined.txt")
mic <- na.omit(mic_raw)

mic_cnn<-subset(mic, mic$cn==1)
mic_cnv<-subset(mic, mic$cn!=1)

pdf("C:/Gresham/tiny_projects/Project_Grace/Review_GB/trans_per_insert/SFig11B_cnn_notFC.pdf")
plot(log2(mic_cnn$insertions), log2(mic_cnn$mrna), col = alpha("black",0.2))
fit<-lm(log2(mic_cnn$mrna) ~ log2(mic_cnn$insertions))
abline(fit)
summary(fit)
dev.off()

pdf("C:/Gresham/tiny_projects/Project_Grace/Review_GB/trans_per_insert/SFig11C_cnn_notFC.pdf")
plot(log2(mic_cnv$insertions), log2(mic_cnv$mrna), col = alpha("black",0.2))
fit<-lm(log2(mic_cnv$mrna) ~ log2(mic_cnv$insertions))
abline(fit)
summary(fit)
dev.off()

#Supplemental_Fig_S13 
library(scales)
mic_raw <- read.delim("C:/Gresham/tiny_projects/Project_Grace/Review_GB/trans_per_insert/mrna_insertions_cn_ratio_combined.txt")
mic <- na.omit(mic_raw)

mic_cnv<-subset(mic, mic$cn!=1)
plot(log2(mic_cnv$insertions), (mic_cnv$cn), col = alpha("black",0.2))
#

cn1<-subset(mic, mic$cn==1)
cn2<-subset(mic, mic$cn==2)
cn3<-subset(mic, mic$cn==3)
cn4<-subset(mic, mic$cn==4)

median(cn1$insertions)/1
median(cn2$insertions)/2
median(cn3$insertions)/3
median(cn4$insertions)/4

length(cn1$insertions)
length(cn2$insertions)
length(cn3$insertions)
length(cn4$insertions)

pdf("C:/Gresham/tiny_projects/Project_Grace/Review_GB/trans_per_insert/S8NEW_insertions_by_cn.pdf")
boxplot(log2(cn1$insertions), log2(cn2$insertions),
        log2(cn3$insertions), log2(cn4$insertions)
        , notch=TRUE)
dev.off()

#Analysis log2FC v Growth Rate
rel_growth_YPGal <- read.csv("C:/Gresham/tiny_projects/Project_Grace/Review_GB/rel_growth_YPGal.csv")
rel_cumulative_log2FC <- read.delim("C:/Gresham/tiny_projects/Project_Grace/Review_GB/rel_cumulative_log2FC.txt")

log2fc_growth<-merge(rel_cumulative_log2FC, rel_growth_YPGal, by="strain")

pdf("C:/Gresham/tiny_projects/Project_Grace/Review_GB/Supplemental_log2FC_growth.pdf")
plot(log2fc_growth$c_log2FC, log2fc_growth$mean_r_norm)
fit<-lm(log2fc_growth$mean_r_norm ~ log2fc_growth$c_log2FC)
abline(fit)
summary(fit)
dev.off()
